package topdown.operator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import topdown.data_structures.*;
import topdown.concrete_operator.*;
import static topdown.concrete_operator.ConcreteOperator.*;

public class RecursiveOperator implements Operator {

    private Operator o;
    private HashMap<String, Boolean> memL;
    private HashMap<Integer, Boolean> memU;
    private HashSet<Integer> visitedL;
    private boolean visitedU;

    public void setBody(Operator o) {
        this.o = o;
        memL = new HashMap<>();
        memU = new HashMap<>();
        visitedL = new HashSet<>();
        visitedU = false;
    }

    @Override
    public ConcreteOperator instance() {
        int U = compute();

        if (U % 2 == 0) return o.instance(U, compute(U));
        return o.instance(U - 1, compute(U - 1));
    }

    public int compute() {
        int U = 3;
        while (this.changes(U)) U++;
        return U;
    }

    public int compute(int U) {
        int L = 2;
        while (this.changes(U, L)) L++;
        return L;
    }
    
    @Override
    public ConcreteOperator instance(int U, int L) {
        if (U <= 0 || L <= 0) return new EmptyOperator();
        return o.instance(U, L - 1);
    }

    @Override
    public boolean changes(int U, int L) {
        if (visitedL.contains(U)) return false;
        visitedL.add(U);
        boolean skip = o.changes(U, L);
        visitedL.remove(U);
        if (skip) return true;

        String value = U + ";" + L;
        if (memL.containsKey(value)) return memL.get(value);

        ConcreteOperator o1, o2;
        o1 = o.instance(U, L);
        o2 = o.instance(U, L - 1);

        if (!isSubset(o1, o2)) {
            memL.put(value, true);
            return true;
        }

        o1.reset(); o2.reset();

        if (!isSubset(o2, o1)) {
            memL.put(value, true);
            return true;
        }

        memL.put(value, false);
        return false;
    }

    @Override
    public boolean changes(int U) {
        if (visitedU) return false;
        visitedU = true;
        boolean skip = o.changes(U);
        visitedU = false;
        if (skip) return true;

        if (memU.containsKey(U)) return memU.get(U);

        ConcreteOperator o1, o2;
        o1 = o.instance(U, compute(U));
        o2 = o.instance(U - 2, compute(U - 2));

        if (!isSubset(o1, o2)) {
            memU.put(U, true);
            return true;
        }

        o1.reset(); o2.reset();

        if (!isSubset(o2, o1)) {
            memU.put(U, true);
            return true;
        }

        memU.put(U, false);
        return false;
    }

}
